import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import MonitoraggioSpecieForm from "../../../../core/Forms/MonitoraggioSpecieForm/MonitoraggioSpecieForm";
import {authUserQuery,speciesProgettoQuery} from "../../../../api/queries";
import Loading from "../../../../core/Loading/Loading";

class Create extends Component {

  constructor(props) {
    super(props);

    this.state = {
      submitting: false,
      error: false,
    };
  }

  render() {

	 console.log('utenteSessione')
	  console.log(this.props.utenteSessione)

    if(this.props.data.loading) {
      return(<Loading/>);
    }

    return (
      <div className="container" style={{marginBottom: '20px'}}>
        <h1>Nuovo Monitoraggio Specie</h1>
        <MonitoraggioSpecieForm
          errorMessage={"Errore durante la creazione del Monitoraggio Specie"}
          data={this.props.data}
	  utenteSessione={this.props.utenteSessione}
          submitMutation={gql`
                    mutation($monitoraggio: MonitoraggioSpecieInput) {
                        updateMonitoraggioSpecie(monitoraggioSpecie: $monitoraggio) {
                            id
                        }
                    }`} />
      </div>
    )
  }
}

export default compose(
  graphql(speciesProgettoQuery),
    graphql(authUserQuery, {name: 'utenteSessione'})
)(Create);

Create.defaultProps = {};

Create.propTypes = {};
